<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
* Please browse readme.txt for credits and forking information
 * @package Lighthouse
 */

?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>" />
  <meta name="viewport" content="width=device-width" />
  <link rel="profile" href="http://gmpg.org/xfn/11" />
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

  <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
  <div id="page" class="hfeed site">
    <header id="masthead"  role="banner" class="main-header">
        <nav class="navbar navbar-expand-lg lh-nav-bg-transform navbar-fixed-top" role="navigation"> 
            <!-- Brand and toggle get grouped for better mobile display --> 
            <div class="navbar-logo">
                <div class="container" >
                    <div class="navbar-header"> 
                        <div class="logo-container">
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">
                                <?php                                
                                    the_custom_logo();
                                ?> 
                            </a>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>">                            
                              <div class="logo-name">
                                  <h1><?php bloginfo( 'name' ); ?></h1>
                                  <span>Shipping</span>
                              </div>
                            </a>
                            <?php if ( has_nav_menu( 'primary' ) ) { ?>
                                <button type="button" class="navbar-toggler"> 
                                    <span class="navbar-toggler-icon"></span> 
                                </button> 
                            <?php } ?>
                        </div>
                    </div> 
                </div><!--#container-->
            </div>
            <div class="navigation-menu" id="navigation_menu">
                <div class="container">
                    <div class="navbar-menu">
                        <?php if ( has_nav_menu( 'primary' ) ) {
                          lighthouse_header_menu(); // main navigation 
                        }
                        ?>
                        <!-- <div id="nav_arrow" class="top-nav_arrow"></div> -->
                    </div>
                </div>
            </div>

        </nav>

        <div class="site-header">
          <div class="site-branding">   
          <a class="home-link" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home">
              <?php if ( get_theme_mod( 'toggle_header_text' ) == '' ) : ?>
                <span class="site-title"><?php bloginfo( 'name' ); ?></span>
                <span class="site-description"><?php bloginfo( 'description' ); ?></span>
              <?php else : ?>
              <?php endif; ?>
            </a>
          </div><!--.site-branding-->
        </div><!--.site-header--> 
    </header>    


      <div class="container"> 
        <div class="row">
          <div class="col-md-4">
            <?php dynamic_sidebar( 'top_widget_left' ); ?>
          </div>
          <div class="col-md-4">
           <?php dynamic_sidebar( 'top_widget_middle' ); ?>
         </div>
         <div class="col-md-4">
          <?php dynamic_sidebar( 'top_widget_right' ); ?>
        </div>

      </div>
    </div>

    <div id="content" class="site-content">