<?php
/**
 * The template for displaying the footer.
 *
 * Please browse readme.txt for credits and forking information
 * Contains the closing of the #content div and all content after
 *
 * @package Lighthouse
 */
?>


</div><!-- #content -->
<?php
$title = "Get in touch";
$subtitle = "Let us craft the right solutions for your marine needs.";
$image = "http://enghup.webpreview.sg/wp-content/uploads/2019/04/Layer-5.jpg";
if(get_field( "title", $id )){
	$title = get_field( "title", $id  );
}
if(get_field( "subtitle", $id  )){
	$subtitle = get_field( "subtitle", $id  );
}
if(get_field( "image", $id  )){
	$image = get_field( "image", $id  );
}
?>
<div id="get-in_touch" class="footer-get-in_touch">
	<div class="container">
		<div class="section-title">
			<h2><?php echo $title; ?></h2>
			<p><?php echo $subtitle; ?></p>
		</div>
	</div>	
	<div class="get-in_touch-content">
		<div class="container">
			<div class="row">
				<div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-4">
					<div class="row">
						<div class="col-12 col-sm-6 col-md-12 col-lg-6 col-xl-6">
							<div class="get-in_touch-box">
								<div class="company-logo">
									<img class="alignnone" src="http://enghup.webpreview.sg/wp-content/uploads/2019/04/logo.png" alt=""/>
								</div>
								<div class="company-text">
									<h5 class="company-name">Eng Hup Shipping</h5>
									<p class="company-address">1 Maritime Square
										Lobby B #09-36
										Harbourfront Centre
										Singapore 099253
									</p>
									<ul class="list-unstyled company-contact_list">
									 	<li><label>T</label>65 6276 6831</li>
									 	<li><label>F</label>65 6276 0351</li>
									 	<li><label>E</label>ehs@enghup86.com.sg</li>
									</ul>
								</div>
							</div>
						</div>
						<div class="col-12 col-sm-6 col-md-12 col-lg-6 col-xl-6">
							<div class="get-in_touch-box">
								<div class="company-logo">
									<img class="alignnone wp-image-93 size-full" src="http://enghup.webpreview.sg/wp-content/uploads/2019/04/Vector-Smart-Object.png" alt="" width="153" height="42" />
								</div>
								<div class="company-text">
									<h5 class="company-name">Bee Sin Shipyard</h5>
									<p class="company-address">62 Penjuru Lane
										Singapore 609208
									</p>
									<ul class="list-unstyled company-contact_list">
									 	<li><label>T</label>65 6268 2527</li>
									 	<li><label>F</label>65 6268 4101</li>
									 	<li><label>E</label>admin@beesin83.com.sg</li>
									</ul>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-12 col-sm-12 col-md-6 col-lg-6 col-xl-4">
					<div class="get-in_touch-form">
						<?php echo do_shortcode( '[contact-form-7 id="91" title="Contact form"]' ) ?>
					</div>
				</div>
			</div>
		</div>
		<div class="get-in_touch-bg" style="background-image: url('<?php echo $image; ?>');">
			<!-- <img class="alignnone wp-image-92 size-full" src="" alt="" width="750" height="660" /> -->
		</div>
		<div class="contact-info">
			<div class="contact-text">
				<h6>
					Thank you for contacting us.
					We’ll be in touch.
				</h6>
				<p>Your enquiry has been successfully submitted. 
				We will reach out to you as soon as possible.</p>
				<div class="contact-popup_btn">
					<a class="btn btn-outline-white contact-close" href="javascript:;">CLOSE</a>
				</div>
			</div>
		</div>
	</div>
</div>

<footer id="colophon" class="site-footer" role="contentinfo">
	<div class="footer-widget-wrapper">
		<div class="container">
			<div class="row">
				<div class="col-12">
					<?php dynamic_sidebar( 'footer_widget_title' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-2">
					<?php dynamic_sidebar( 'footer_widget_1' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-2">
					<?php dynamic_sidebar( 'footer_widget_2' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-2">
					<?php dynamic_sidebar( 'footer_widget_3' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-2">
					<?php dynamic_sidebar( 'footer_widget_4' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-1">
					<?php dynamic_sidebar( 'footer_widget_5' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-1">
					<?php dynamic_sidebar( 'footer_widget_6' ); ?> 
				</div>
				<div class="col-6 col-md-3 col-lg-2">
					<?php dynamic_sidebar( 'footer_widget_7' ); ?> 
				</div>
			</div>
		</div>
	</div>
	<div class="site-info">
		<!-- <?php echo '&copy; '.esc_html(date_i18n(__('Y','lighthouse'))); ?> <?php bloginfo( 'name' ); ?>
			<?php printf( __( '| Powered by ', 'lighthouse' ) ); ?>
			<a href="<?php echo esc_url( __( 'https://outstandingthemes.com/', 'lighthouse' ) ); ?>"><?php printf( __( 'Outstandingthemes', 'lighthouse' ) ); ?></a> -->
			<p>Copyright ©   Eng Hup Shipping Pte Ltd.   All Rights Reserved.</p>
			<p class="">Eng Hup Shipping is an ISO9001 and ISO14001 certified organisation.</p>
	</div><!-- .site-info -->
</footer><!-- #colophon -->


</div><!-- #page -->

<?php wp_footer(); ?>

<script type="text/javascript">
	 jQuery(document).on('keyup', '.wpcf7-form-control', function () {
        if (jQuery(this).val().length == 0) {
            jQuery(this).closest('.form-group').removeClass('floating-focus');
        }
        else {
            jQuery(this).closest('.form-group').addClass('floating-focus');
        }
    });
    jQuery('.wpcf7-form-control').each(function () {
        if (jQuery(this).val() == '') {
            jQuery(this).parents('.form-group').removeClass('floating-focus');
        }
        else {
            jQuery(this).parents('.form-group').addClass('floating-focus');
        }
    });
    jQuery(document).ready(function(){
    	var hash = window.location.hash;
		jQuery('hash').load(function(){
			$(this).scrollTop(50);
		});
    });
</script>

</body>
</html>
