<?php 
add_filter('use_block_editor_for_post', '__return_false');
add_action( 'init' , 'remove_default_action', 20 );
function remove_default_action() {
        remove_action('woocommerce_before_main_content', 'wp_bootstrap_4_woocommerce_wrapper_before' );
        remove_action('woocommerce_after_main_content', 'wp_bootstrap_4_woocommerce_wrapper_before' );
		remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
		remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10, 0); 
}

/**
 * Enqueue scripts and styles
 */
remove_action( 'woocommerce_before_main_content', 'action_woocommerce_before_main_content', 10, 2 );
function mychildtheme_enqueue_styles() {
    $parent_style = 'parent-style';

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
   
     wp_enqueue_script( 'custom', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), '20120206', true );
     wp_enqueue_script( 'api','http://maps.google.com/maps/api/js?key=AIzaSyDDeuwqIV_761BDTWvKSyK-tsLOH1PZ-qo&amp;language=en');
     wp_enqueue_script( 'infobox', get_stylesheet_directory_uri() . '/assets/js/infobox.min.js', array('jquery'), '20120206', true );
     wp_enqueue_script( 'markerclusterer', get_stylesheet_directory_uri() . '/assets/js/markerclusterer.js', array('jquery'), '20120206', true );
     wp_enqueue_script( 'map', get_stylesheet_directory_uri() . '/assets/js/map.js', array('jquery'), '20120206', true );
}
add_action( 'wp_enqueue_scripts', 'mychildtheme_enqueue_styles' );


/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function wintertime_widgets_init() {
	
	register_sidebar( array(
		'name'          => esc_html__( 'Footer Top Column 1', 'wp-bootstrap-4' ),
		'id'            => 'footer-top-1',
		'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-4' ),
		'before_widget' => '<section id="%1$s" class="widget wp-bp-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h5">',
		'after_title'   => '</h5>',
	) );

	register_sidebar( array(
		'name'          => esc_html__( 'Footer Top Column 2', 'wp-bootstrap-4' ),
		'id'            => 'footer-top-2',
		'description'   => esc_html__( 'Add widgets here.', 'wp-bootstrap-4' ),
		'before_widget' => '<section id="%1$s" class="widget wp-bp-footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h5 class="widget-title h5">',
		'after_title'   => '</h5>',
	) );

}
add_action( 'widgets_init', 'wintertime_widgets_init' );

function ajax_search_enqueues() {
    if ( is_search() ) {
    	wp_enqueue_script( 'ajax-search', get_stylesheet_directory_uri() . '/assets/js/ajax-search.js', array( 'jquery' ), '1.0.0', true );
        wp_localize_script( 'ajax-search', 'myAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
    }
}

add_action( 'wp_enqueue_scripts', 'ajax_search_enqueues' );


add_filter( 'woocommerce_after_shop_loop_item', 'loop_display_ingredients', 15 );
function loop_display_ingredients() {
    global $product;
    // The attribute slug
    $attribute = 'color';
    // Get attribute term names in a coma separated string
    //$term_names = $product->get_attribute( $attribute );
	$terms = wp_get_post_terms($product->get_id(), 'pa_color', 'all');
	if($terms){
	$html = '<div class="color-attribute">';
	foreach ( $terms as $term ) {
		$name = $term->name;
		$color = get_term_meta( $term->term_id, 'color', true );
		list( $r, $g, $b ) = sscanf( $color, "#%02x%02x%02x" );
		$html .= sprintf(
			'<span class="swatch swatch-color swatch-%s" style="background-color:%s;color:%s;" title="%s" data-value="%s">%s</span>',
			esc_attr( $term->slug ),
			esc_attr( $color ),
			"rgba($r,$g,$b,0.5)",
			esc_attr( $name ),
			esc_attr( $term->slug ),
			$name
		);
	}
	$html .='</div>';
	echo $html;
	}
}


function woocom_extra_register_fields() {?>
	<div class="form-group">
		<label for="reg_gender"><?php _e( 'Gender', 'woocommerce' ); ?>
			<span class="required">*</span>
			<span class="label-info"> - for personalised content</span>
		</label>
		<div class="custom-control custom-radio custom-control-inline">
			<input type="radio" checked name="gender" id="gendermale"  value="male" class="custom-control-input ">
			<label class="custom-control-label" for="gendermale">Male</label>
		</div>
			<div class="custom-control custom-radio custom-control-inline">
			<input type="radio" name="gender" id="genderfemale" value="female" class="custom-control-input">
			<label class="custom-control-label" for="genderfemale">Female</label>
		</div>
	</div>
	<div class="form-group">
		<label for="reg_billing_first_name"><?php _e( 'Name', 'woocommerce' ); ?>
			<span class="required">*</span>
			<span class="label-info"> - let us know what to call you!</span>
		</label>
		<input type="text" class="input-text login-form-control" name="billing_first_name" id="reg_billing_first_name" placeholder="Enter your name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
	</div>
	<div class="form-group day_of_birth_main">
		<label for=""><?php _e( 'Birthday', 'woocommerce' ); ?>
			<span class="required">*</span>
			<span class="label-info"> - tell us and get a birthday treat from us!</span>
		</label>
		<div class="dob_filed-box">
			<select class="birthday_select login-form-control" name="day_of_birth" id="day_of_birth">
				<option value="">DD</option>
				<?php 
				for ($i=1; $i < 32; $i++) { 
				?>
				<option value="<?php echo $i;?>"><?php echo $i;?></option>
				<?php
				}
				?>
			</select>
			<select class="birthday_select login-form-control" name="month_of_birth" id="month_of_birth">
				<option value="">MM</option>
				<?php 
				$montharray = array('01','02','03','04','05','06','07','08','09','10','11','12');
				foreach ($montharray as $key => $month) {
				?>
					<option value="<?php echo $month;?>"><?php echo $month;?></option>
				<?php
				}
				?>
			</select>
			<select class="birthday_select login-form-control" name="year_of_birth" id="year_of_birth">
				<option value="">YYYY</option>
				<?php 
				$currentYear = date("Y");
				for ($i=1920; $i < $currentYear; $i++) { 
				?>
				<option value="<?php echo $i;?>"><?php echo $i;?></option>
				<?php
				 }
				?>
			</select>
		</div>
	</div>	

<?php
 }
add_filter( 'woocommerce_register_form', 'woocom_extra_register_fields');

/******************* Validation all filed *********************/
 function wooc_validate_extra_register_fields( $username, $email, $validation_errors ) {

     if ( isset( $_POST['gender'] ) && empty( $_POST['gender'] ) ) {
         $validation_errors->add( 'gender_error', __( ' Gender is required!.', 'woocommerce' ) );
     }

     if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
         $validation_errors->add( 'billing_first_name_error', __( ' Name is required!.', 'woocommerce' ) );
     }

     if ( isset( $_POST['day_of_birth'] ) && empty( $_POST['day_of_birth'] ) ) {
         $validation_errors->add( 'day_of_birth_error', __( ' Day is required!.', 'woocommerce' ) );
     }

     if ( isset( $_POST['month_of_birth'] ) && empty( $_POST['month_of_birth'] ) ) {
         $validation_errors->add( 'month_of_birth_error', __( ' Month is required!.', 'woocommerce' ) );
     }

     if ( isset( $_POST['year_of_birth'] ) && empty( $_POST['year_of_birth'] ) ) {
         $validation_errors->add( 'year_of_birth_error', __( ' Year is required!.', 'woocommerce' ) );
     }

 }
 add_action( 'woocommerce_register_post', 'wooc_validate_extra_register_fields', 10, 3);

 /********************* Save register extra filed ************************/
function wooc_save_extra_register_fields( $customer_id ) {
    if ( isset( $_POST['gender'] ) ) {
        update_user_meta( $customer_id, 'gender', sanitize_text_field( $_POST['gender'] ) );
    }
   	if ( isset( $_POST['billing_first_name'] ) ) {
        update_user_meta( $customer_id, 'first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
        update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
   	}
    if ( isset( $_POST['day_of_birth'] ) ) {
        update_user_meta( $customer_id, 'day_of_birth', sanitize_text_field( $_POST['day_of_birth'] ) );
    }
    if ( isset( $_POST['month_of_birth'] ) ) {
        update_user_meta( $customer_id, 'month_of_birth', sanitize_text_field( $_POST['month_of_birth'] ) );
    }
    if ( isset( $_POST['year_of_birth'] ) ) {
        update_user_meta( $customer_id, 'year_of_birth', sanitize_text_field( $_POST['year_of_birth'] ) );
    }
}
add_action( 'woocommerce_created_customer', 'wooc_save_extra_register_fields' );

function save_favorite_color_account_details( $customer_id ) {
	if ( isset( $_POST['gender'] ) ) {
        update_user_meta( $customer_id, 'gender', sanitize_text_field( $_POST['gender'] ) );
    }   
    if ( isset( $_POST['day_of_birth'] ) ) {
        update_user_meta( $customer_id, 'day_of_birth', sanitize_text_field( $_POST['day_of_birth'] ) );
    }
    if ( isset( $_POST['month_of_birth'] ) ) {
        update_user_meta( $customer_id, 'month_of_birth', sanitize_text_field( $_POST['month_of_birth'] ) );
    }
    if ( isset( $_POST['year_of_birth'] ) ) {
        update_user_meta( $customer_id, 'year_of_birth', sanitize_text_field( $_POST['year_of_birth'] ) );
    }
}


add_action( 'woocommerce_save_account_details', 'save_favorite_color_account_details', 12, 1 );


// **************** custom texonomy *********************
if ( ! function_exists('custom_post_type_location') ) {

// Register location Custom Post Type
function custom_post_type_location() {

	$labels = array(
		'name'                  => _x( 'Locations', 'Post Type General Name', 'wintertime' ),
		'singular_name'         => _x( 'Locations', 'Post Type Singular Name', 'wintertime' ),
		'menu_name'             => __( 'Locations', 'wintertime' ),
		'name_admin_bar'        => __( 'Locations', 'wintertime' ),
		'archives'              => __( 'Location Archives', 'wintertime' ),
		'attributes'            => __( 'Location Attributes', 'wintertime' ),
		'parent_item_colon'     => __( 'Parent Location:', 'wintertime' ),
		'all_items'             => __( 'All Locations', 'wintertime' ),
		'add_new_item'          => __( 'Add New Locations', 'wintertime' ),
		'add_new'               => __( 'Add New', 'wintertime' ),
		'new_item'              => __( 'New Item', 'wintertime' ),
		'edit_item'             => __( 'Edit Location', 'wintertime' ),
		'update_item'           => __( 'Update Location', 'wintertime' ),
		'view_item'             => __( 'View Location', 'wintertime' ),
		'view_items'            => __( 'View Location', 'wintertime' ),
		'search_items'          => __( 'Search Location', 'wintertime' ),
		'not_found'             => __( 'Not found', 'wintertime' ),
		'not_found_in_trash'    => __( 'Not found in Trash', 'wintertime' ),
		'featured_image'        => __( 'Featured Image', 'wintertime' ),
		'set_featured_image'    => __( 'Set featured image', 'wintertime' ),
		'remove_featured_image' => __( 'Remove featured image', 'wintertime' ),
		'use_featured_image'    => __( 'Use as featured image', 'wintertime' ),
		'insert_into_item'      => __( 'Insert into Location', 'wintertime' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Location', 'wintertime' ),
		'items_list'            => __( 'Locations list', 'wintertime' ),
		'items_list_navigation' => __( 'Locations list navigation', 'wintertime' ),
		'filter_items_list'     => __( 'Filter Locations list', 'wintertime' ),
	);
	$args = array(
		'label'                 => __( 'Locations', 'wintertime' ),
		'description'           => __( 'Post Type Description', 'wintertime' ),
		'labels'                => $labels,
		// 'supports'              => array( 'title', 'editor', 'thumbnail', 'post-formats' ),
		'hierarchical'          => false,
		'public'                => true,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'publicly_queryable'    => true,
		'capability_type'       => 'page',
	);
	register_post_type( 'location', $args );

}
add_action( 'init', 'custom_post_type_location', 0 );

}


if ( ! function_exists( 'direction' ) ) {

// Register Custom Taxonomy
function custom_direction() {

	$labels = array(
		'name'                       => _x( 'Directions', 'Post General Name', 'text_domain' ),
		'singular_name'              => _x( 'Directions', 'Post Singular Name', 'text_domain' ),
		'menu_name'                  => __( 'Directions', 'text_domain' ),
		'name_admin_bar'             => __( 'Directions', 'wintertime' ),
		'all_items'                  => __( 'All Directions', 'text_domain' ),
		'parent_item'                => __( 'Parent Direction', 'text_domain' ),
		'parent_item_colon'          => __( 'Parent Direction:', 'text_domain' ),
		'new_item_name'              => __( 'New Direction Name', 'text_domain' ),
		'add_new_item'               => __( 'Add New Direction', 'text_domain' ),
		'edit_item'                  => __( 'Edit Direction', 'text_domain' ),
		'update_item'                => __( 'Update Direction', 'text_domain' ),
		'view_item'                  => __( 'View Direction', 'text_domain' ),
		'separate_items_with_commas' => __( 'Separate Directions with commas', 'text_domain' ),
		'add_or_remove_items'        => __( 'Add or remove Directions', 'text_domain' ),
		'choose_from_most_used'      => __( 'Choose from the most used', 'text_domain' ),
		'popular_items'              => __( 'Popular Directions', 'text_domain' ),
		'search_items'               => __( 'Search Directions', 'text_domain' ),
		'not_found'                  => __( 'Not Found', 'text_domain' ),
		'no_terms'                   => __( 'No items', 'text_domain' ),
		'items_list'                 => __( 'Directions list', 'text_domain' ),
		'items_list_navigation'      => __( 'Directions list navigation', 'text_domain' ),
	);
	$args = array(
		'label'                      => __( 'Directions', 'wintertime' ),
		'description'                => __( 'Post Type Description', 'wintertime' ),
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
	);
	register_taxonomy( 'custom_direction', array( 'location' ), $args );

}
add_action( 'init', 'custom_direction', 0 );

}

?>